package jp.kawakubo;

import java.util.ArrayList;
import java.util.List;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

@Stateless(name = "JPASession01Remote")
public class JPASession01Bean implements JPASession01Remote {
    
    @PersistenceContext(unitName = "JPASample02-ejbPU")
    private EntityManager entityManager;

    public JPASession01Bean() {
    }

    public JPASession01Bean(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public List<Meigara> getMeigaras() {
        List<Meigara> meigaras = null;
        Query query = entityManager.createQuery(
                "SELECT m FROM Meigara AS m");
        meigaras = query.getResultList();
        return meigaras;
    }

    public void insertBasketItems(int[] meigaraIds) {
        Basket basket = null;
        Query query = entityManager.createQuery(
                "SELECT b FROM Basket AS b " +
                "WHERE b.userId = :userId")
                .setParameter("userId", "tomoharu");
        List<Basket> baskets = query.getResultList();
        if (baskets.size() == 0) {
            basket = new Basket();
            basket.setUserId("tomoharu");
            entityManager.persist(basket);
            entityManager.flush();
        } else {
            basket = baskets.get(0);
        }

        BasketItem basketItem = null;
        Meigara meigara = null;
        for (int i = 0; i < meigaraIds.length; i++) {
            query = entityManager.createQuery(
                    "SELECT bi " +
                    "FROM BasketItem AS bi INNER JOIN bi.meigara AS m, " +
                    "Basket AS b " +
                    "WHERE m.id = :meigaraId " +
                    "AND b.userId = :userId")
                    .setParameter("meigaraId", meigaraIds[i])
                    .setParameter("userId", "tomoharu");
            List<BasketItem> basketItems = query.getResultList();
            // 買い物かごに同じ銘柄がない場合のみ追加
            if (basketItems.size() == 0) {
                basketItem = new BasketItem();
                meigara = entityManager.find(Meigara.class, meigaraIds[i]);
                basketItem.setBasket(basket);
                basketItem.setMeigara(meigara);
                basketItem.setQuantity(1);
                entityManager.persist(basketItem);
            }
        }
    }

    public List<BasketItemContent> getBasketItems(String userId) {
        // userIdは固定で「tomoharu」を設定
        Query query = entityManager.createQuery(
                "SELECT NEW jp.kawakubo.BasketItemContent" +
                "(bi.id, m.name, m.price, bi.quantity) " +
                "FROM BasketItem AS bi INNER JOIN bi.meigara AS m, " +
                "Basket AS b " +
                "WHERE b.userId = :userId")
                .setParameter("userId", "tomoharu");
        List<BasketItemContent> basketItemContents = query.getResultList();
        return basketItemContents;
    }


    public void updateBasketItems(int[] basketItemIds, int[] allQuantity) {
        for (int i = 0; i < basketItemIds.length; i++) {
            Query query = entityManager.createQuery(
                    "UPDATE BasketItem AS b " +
                    "SET b.quantity = :quantity " +
                    "WHERE b.id = :id")
                    .setParameter("quantity", allQuantity[i])
                    .setParameter("id", basketItemIds[i]);
            query.executeUpdate();
        }
    }

    public List getTotalCharge(List<BasketItemContent> basketItemContents) {
        List totalCharge = new ArrayList();
        int sumItems = 0;
        int shippingCost = 1500;
        int total = 0;
        BasketItemContent basketItemContent = null;
        // 本数変更後の金額の合計を求める
        // getBasketItemsの引数にはuserIdを設定すべきだが、内部で「tomoharu」
        // を固定で設定しているため、ここでは空文字を設定
        for (int i = 0; i < basketItemContents.size(); i++) {
            basketItemContent = basketItemContents.get(i);
            sumItems += (basketItemContent.getPrice() * basketItemContent.getQuantity());
        }

        total = sumItems + shippingCost;
        totalCharge.add(sumItems);
        totalCharge.add(shippingCost);
        totalCharge.add(total);
        return totalCharge;
    }

    public void removeBasket(String userId) {
        Query query = entityManager.createQuery(
                "SELECT b FROM Basket AS b " +
                "WHERE b.userId = 'tomoharu'");
        Basket basket = (Basket)query.getSingleResult();
        entityManager.remove(basket);
    }

}
